import { API_URL } from '@/app/const'

export async function getUsuariosEmpresa(empresa_id ,token) {

  try {
    const response = await fetch(API_URL+'/empresas/'+empresa_id+'/usuarios', {
      headers: {
        Authorization: `Bearer ${token}`, // Usa el token de autenticación del usuario
      },
    });

    if (!response.ok) {
      throw new Error('Error al obtener los usuarios');
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error('Error al obtener los usuarios:', error.message);
    throw error;
  }
}