import { useEffect, useState } from "react";
import {
  UserCircleIcon,
  ChevronDownIcon,
  UserIcon,
  PowerIcon,
} from "@heroicons/react/24/solid";
import { useSession } from "../contexts/SessionContext";

const IconoPerfil = () => {
  // Puedes manejar el estado del icono aquí si es necesario
  const { user } = useSession();
  const [nombreUsuario, setNombreUsuario] = useState("nombre");
  const [permisosUsuario, setPermisosUsuario] = useState("permisos");

  const [menuOpen, setMenuOpen] = useState(false);

  useEffect(() => {
    const fetchData = async () => {
      try {
        
        const usuario = user.usuario;

        if (usuario && usuario.permisos_usuarios) {
          setPermisosUsuario(usuario.permisos_usuarios.nombre_permisos);
          const nombreUsuario = usuario.nombre_usuario.split(" ");

          if (nombreUsuario.length > 3) {
            setNombreUsuario(nombreUsuario[0] + " " + nombreUsuario[2]);
          } else {
            setNombreUsuario(usuario.nombre_usuario);
          }
        }
      } catch (error) {
        console.error("Error al cargar datos:", error);
      }
    };

    fetchData();
  }, [user]);

  const toggleMenu = () => {
    setMenuOpen(!menuOpen);
  };

  return (
    <div className="h-16 w-56">
      <div className="py-2 px-3 bg-[#242745] text-white rounded-md shadow-md">
        <div className="flex items-center">
          <button onClick={toggleMenu} className="relative">
            <UserCircleIcon className="h-12 w-12 cursor-pointer translate-y-0.5 hover:text-slate-300" />

            <div className="absolute bottom-0 right-0 bg-[#242745] rounded-full p-0.5 w-4 h-4 flex justify-center items-center cursor-pointer">
              <ChevronDownIcon className="text-white w-max h-max" />
            </div>
          </button>

          <div className="ml-2">
            <p className="font-bold translate-y-1 capitalize">
              {nombreUsuario}
            </p>
            <p className="capitalize text-sm font-medium text-slate-500">
              {permisosUsuario}
            </p>
          </div>
        </div>
      </div>

      {menuOpen && (
        <div className="fixed grid grid-cols-1 w-56 bg-[#2d3253] text-slate-200 rounded-md shadow-md">
          <button className="flex gap-2 px-4 py-2">
            <UserIcon className="h-6 w-6 text-white" />
            <p>Alternar Menu</p>
          </button>

          <button className="flex gap-2 px-4 py-2">
            <PowerIcon className="h-6 w-6 text-white" />
            <p>Cerrar Sesion</p>
          </button>
        </div>
      )}
    </div>
  );
};

export default IconoPerfil;
