"use client"
import React, { createContext, useState, useContext, useEffect } from 'react';
import { login } from '@/api/login'; // Importa la función de inicio de sesión desde tu API

export const SessionContext = createContext('default');

export function useSession() {
  return useContext(SessionContext);
}

export function SessionProvider({ children }) {
  const [user, setUser] = useState(null);
  const [error, setError] = useState(null);

  
  useEffect(() => {
    // Recuperar los datos de sesión del almacenamiento local al cargar la página
    const savedUser = localStorage.getItem('user');
    if (savedUser) {
      setUser(JSON.parse(savedUser));
    }
  }, []);

  const loginHandler = async (username, password) => {
    try {
      const userData = await login(username, password);
      setUser(userData);
      localStorage.setItem('user', JSON.stringify(userData));
      return userData
      // Almacena los datos del usuario en el estado
    } catch (error) {
      setError('Error al iniciar sesión. Por favor, verifica tus credenciales.');
    }
  };

  const logoutHandler = () => {
    setUser(null);
    localStorage.removeItem('user'); // Borra los datos del usuario al cerrar sesión
  };

  return (
    <SessionContext.Provider value={{ user, error, login: loginHandler, logout: logoutHandler }}>
      {children}
    </SessionContext.Provider>
  );
}