"use client"
import React, { useState } from 'react';
import { IoPerson } from 'react-icons/io5';

const Home = () => {
  // Estado local para almacenar la información del perfil
  const [perfil, setPerfil] = useState({
    nombre: '',
    edad: '',
    ciudad: '',
    // Agrega más campos según sea necesario
  });

  // Manejador de cambios para actualizar el estado del perfil
  const handleChange = (event) => {
    const { name, value } = event.target;
    setPerfil((prevPerfil) => ({
      ...prevPerfil,
      [name]: value,
    }));
  };

  return (

        <div className='p-8'>
          <div className='rounded-md p-4 mb-4 max-w-sm md:max-w-md lg:max-w-lg xl:max-w-xl'>
            <h1 className='flex items-center text-3xl font-bold text-black mb-3 border-b border-black pb-2'>
              <IoPerson size={40} style={{ marginRight: '8px' }} /> Mi perfil
            </h1>
            <div className='border-b-1 border-black w-full'></div>

            {/* Formulario para mostrar y editar la información del perfil */}
            <form className='mt-4'>
              <div className='mb-4'>
                <label htmlFor='nombre' className='block text-sm font-medium text-gray-700'>
                  Nombre
                </label>
                <input
                  type='text'
                  id='nombre'
                  name='nombre'
                  value={perfil.nombre}
                  onChange={handleChange}
                  className='mt-1 p-2 border border-gray-300 rounded-md w-full text-black'
                />
              </div>

              <div className='mb-4'>
                <label htmlFor='edad' className='block text-sm font-medium text-gray-700'>
                  Edad
                </label>
                <input
                  type='text'
                  id='edad'
                  name='edad'
                  value={perfil.edad}
                  onChange={handleChange}
                  className='mt-1 p-2 border border-gray-300 rounded-md w-full text-black'
                />
              </div>

              <div className='mb-4'>
                <label htmlFor='ciudad' className='block text-sm font-medium text-gray-700'>
                  Ciudad
                </label>
                <input
                  type='text'
                  id='ciudad'
                  name='ciudad'
                  value={perfil.ciudad}
                  onChange={handleChange}
                  className='mt-1 p-2 border border-gray-300 rounded-md w-full text-black'
                />
              </div>

              {/* Agrega más campos según sea necesario */}

              <button
                type='submit'
                className='bg-blue-500 text-white p-2 rounded-md hover:bg-blue-600'
              >
                Guardar cambios
              </button>
            </form>
          </div>
        </div>
  );
};

export default Home;
