import React, { useEffect, useState } from "react";
import Markdown from "react-markdown";

const Modalterminos = ({ isOpen, onClose, valid, onCheck, onAccept }) => {
  const [terminosText, setTerminosText] = useState("");

  useEffect(() => {
    const fetchTerminosText = async () => {
      try {
        const response = await fetch("/terminos.md"); // Reemplaza con la ruta correcta, texto txt esta en public
        const text = await response.text();
        setTerminosText(text);
      } catch (error) {
        console.error("Error fetching terminos.txt", error);
      }
    };

    if (isOpen) {
      fetchTerminosText();
    }
  }, [isOpen]);

  useEffect(() => {
    const handleOutsideClick = (event) => {
      if (!isOpen) return;
      if (!event.target.closest("#modal-terminos")) {
        onClose();
      }
    };

    document.addEventListener("mousedown", handleOutsideClick);

    return () => {
      document.removeEventListener("mousedown", handleOutsideClick);
    };
  }, [isOpen, onClose]);

  const handleClose = () => {
    // Solo cierra si el checkbox está marcado
    if (valid) {
      onClose();
      onAccept();
    }
  };

  if (!isOpen) return null;
  return (
    <div className="fixed top-0 left-0 w-full h-full flex items-center justify-center bg-gray-800 bg-opacity-75 z-50">
      <div
        id="modal-terminos"
        className="bg-white p-4 rounded-lg relative modal-content text-black"
      >
        <div className="mb-1 text-2xl font-bold">Términos y Condiciones</div>
        <div className="mt-2 border-2 rounded border-gray-400 h-96 w-[600px] mb-3 scroll-m-1 overflow-y-auto">
          <Markdown className="prose">{terminosText}</Markdown>
        </div>
        <div className="flex items-center justify-center">
          <input
            type="checkbox"
            checked={valid}
            onChange={onCheck}
            className="my-2 mr-1 h-5 w-5 rounded-md text-blue-600 border-gray-300 focus:ring-1 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 dark:bg-gray-700 dark:border-gray-600"
          />
          <label className="text-base">Acepto términos y condiciones</label>
        </div>

        <div className="flex w-full justify-center">
          <button
            onClick={handleClose}
            disabled={!valid}
            className={`cursor-pointer text-white mt-1 rounded-md w-32 text-xl ${
              valid
                ? "border-blue-700 bg-blue-600 hover:bg-blue-400"
                : "bg-gray-400"
            } p-2`}
          >
            Enviar
          </button>
        </div>
      </div>
    </div>
  );
};

export default Modalterminos;
