import React, { useState } from "react";
import Sidebar from "../app/components/sidebar";
import Card from "../app/components/busquedaCard";
import { IoIosSend, IoMdDownload } from "react-icons/io";
import { IoSearch } from "react-icons/io5";
import ProfileIcon from '../app/components/IconoPerfil'

const Busqueda = () => {
  const [filtroId, setFiltroId] = useState("");
  const [fechaInicio, setFechaInicio] = useState("");
  const [fechaFin, setFechaFin] = useState("");
  const [paginaActual, setPaginaActual] = useState(1);
  const [tarjetasFiltradas, setTarjetasFiltradas] = useState([]);

  const estiloConImagen = {
    backgroundImage: 'url("/assets/Fondo.jpg")',
    backgroundSize: 'cover',
    backgroundRepeat: 'no-repeat',
    
  };

  const datosTarjetas = [
    {
      ID: "13452",
      Proyecto: "Proyecto L",
      fecha_subida: "2023-01-02",
      fecha_postulacion: "2023-01-09",
    },
    {
      ID: "23462",
      Proyecto: "Proyecto J",
      fecha_subida: "2023-01-03",
      fecha_postulacion: "2023-01-08",
    },
    {
      ID: "3645634",
      Proyecto: "Proyecto A",
      fecha_subida: "2023-01-04",
      fecha_postulacion: "2023-01-07",
    },
    {
      ID: "4236356",
      Proyecto: "Proyecto V",
      fecha_subida: "2023-01-05",
      fecha_postulacion: "2023-01-06",
    },
    {
      ID: "535464",
      Proyecto: "Proyecto D",
      fecha_subida: "2023-01-06",
      fecha_postulacion: "2023-01-05",
    },
    {
      ID: "34356",
      Proyecto: "Proyecto G",
      fecha_subida: "2023-01-01",
      fecha_postulacion: "2023-01-05",
    },
  ];

  const tarjetasPorPagina = 5;
  const indiceInicial = (paginaActual - 1) * tarjetasPorPagina;
  const indiceFinal = paginaActual * tarjetasPorPagina;

  const cambiarPagina = (nuevaPagina) => {
    setPaginaActual(nuevaPagina);
  };

  const realizarBusqueda = () => {
    const tarjetasFiltradas = datosTarjetas.filter((tarjeta) => {
      const filtroIdValido =
        tarjeta.ID.toLowerCase().includes(filtroId.toLowerCase()) ||
        filtroId === "";

      const fechaPostulacion = new Date(tarjeta.fecha_postulacion);

      const filtroFechaValido =
        (!fechaInicio || fechaPostulacion >= new Date(fechaInicio)) &&
        (!fechaFin || fechaPostulacion <= new Date(fechaFin));

      return filtroIdValido && filtroFechaValido;
    });

    setTarjetasFiltradas(tarjetasFiltradas);
  };

  const limpiarFiltros = () => {
    setFiltroId("");
    setFechaInicio("");
    setFechaFin("");
    setTarjetasFiltradas([]);
    setPaginaActual(1);
  };

  const handleFormSubmit = (e) => {
    e.preventDefault(); // Evitar que el formulario realice una recarga de la página al enviar

    // Llamar a la función de búsqueda al presionar Enter
    realizarBusqueda();
  };

  return (
    <div className="flex">
      <Sidebar />
      <ProfileIcon />
      <div className='flex-1' style={estiloConImagen}>
        <hr />
        <h1 className="text-3xl font-bold text-black pb-2 mb-3 py-8 flex items-center px-8">
          <IoSearch size={30} /> Búsqueda
        </h1>
        <div className="mx-4 border-b border-black w-[45%]"></div>
        <div className="border border-[#073673] rounded-md mx-4 bg-[#07338C]  my-4 relative w-[80%]">
          <div className="p-4">
            <div className="max-w-sm md:max-w-md lg:max-w-lg xl:max-w-xl">
              <form onSubmit={handleFormSubmit}>
                <div className="md:flex md:justify-end w-[80vw] lg:w-[80vw]">
                  <div className="md:mr-auto mt-4 flex">
                    <div className="flex items-center">
                      <label className="mr-2 text-lg text-white">ID:</label>
                      <input
                        type="text"
                        placeholder="Ej:13452"
                        value={filtroId}
                        onChange={(e) =>
                          setFiltroId(e.target.value.toUpperCase())
                        }
                        className="border rounded-md py-2 px-3 text-lg text-black"
                      />
                    </div>
                    <div className="flex items-center">
                      <label className="mr-2 mx-2 text-lg text-white">
                        Fecha de Inicio:
                      </label>
                      <input
                        type="date"
                        placeholder="Fecha de Inicio"
                        value={fechaInicio}
                        onChange={(e) => setFechaInicio(e.target.value)}
                        className="border rounded-md py-2 px-3 text-lg text-black"
                      />
                    </div>
                    <div className="flex items-center">
                      <label className="mr-2 mx-2 text-lg text-white">
                        Fecha de Fin:
                      </label>
                      <input
                        type="date"
                        placeholder="Fecha de Fin"
                        value={fechaFin}
                        onChange={(e) => setFechaFin(e.target.value)}
                        className="border rounded-md py-2 px-3 text-lg text-black"
                      />
                    </div>
                    <button
                      type="submit"
                      className="bg-blue-300 px-3 py-2 rounded-md text-black ml-4 transition duration-300 ease-in-out hover:bg-green-400 hover:shadow-md"
                    >
                      Buscar
                    </button>
                    <button
                      type="button"
                      className="bg-blue-600 px-3 py-2 rounded-md text-white ml-4 transition duration-300 ease-in-out hover:bg-blue-500 hover:shadow-md"
                      onClick={limpiarFiltros}
                    >
                      Limpiar Filtros
                    </button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>

        {tarjetasFiltradas.length === 0 && (
          <div className="p-4 text-lg text-black">
            No hay postulaciones que coincidan con los criterios de búsqueda.
          </div>
        )}

        {tarjetasFiltradas
          .slice(indiceInicial, indiceFinal)
          .map((data, index) => (
            <Card key={index} data={data} />
          ))}

        <div className="flex justify-center mt-4 mb-4">
          <button
            className={`mx-1 px-3 py-1 rounded-md ${
              paginaActual === 1 ? " cursor-not-allowed" : "bg-blue-400"
            }`}
            onClick={() => {
              if (paginaActual > 1) {
                cambiarPagina(1);
              }
            }}
            disabled={paginaActual === 1}
          >
            {"<<"}
          </button>
          {Array.from(
            { length: Math.ceil(tarjetasFiltradas.length / tarjetasPorPagina) },
            (_, i) => (
              <button
                key={i}
                className={`mx-1 px-3 py-1 rounded-full ${
                  paginaActual === i + 1 ? "bg-blue-500 text-white" : ""
                }`}
                onClick={() => cambiarPagina(i + 1)}
              >
                {i + 1}
              </button>
            )
          )}
          <button
            className={`mx-1 px-3 py-1 rounded-md ${
              paginaActual ===
              Math.ceil(tarjetasFiltradas.length / tarjetasPorPagina)
                ? " cursor-not-allowed"
                : "bg-blue-400"
            }`}
            onClick={() => {
              if (
                paginaActual <
                Math.ceil(tarjetasFiltradas.length / tarjetasPorPagina)
              ) {
                cambiarPagina(
                  Math.ceil(tarjetasFiltradas.length / tarjetasPorPagina)
                );
              }
            }}
            disabled={
              paginaActual ===
              Math.ceil(tarjetasFiltradas.length / tarjetasPorPagina)
            }
          >
            {">>"}
          </button>
        </div>
      </div>
    </div>
  );
};

export default Busqueda;
