import React, { useState, useEffect } from 'react';
import Sidebar from '../app/components/sidebar';
import { GoPeople } from "react-icons/go";
import axios from 'axios';

const Empresas = () => {
  const [empresas, setEmpresas] = useState([]);// Tu lista de empresas

  useEffect(() => {
    // Realizar la solicitud HTTP al back-end
    axios
      .get(
        "https://kct6q4f3-8000.brs.devtunnels.ms/empresas/?skip=0&limit=10"
        )
            .then((response) => {
              console.log(response.data);
              // Actualizar el estado con los datos recibidos
              setEmpresas(response.data);
            })
            .catch((error) => {
              console.error("Error al obtener datos del back-end:", error);
            });
        }, []);
 
  const [showConfirmation, setShowConfirmation] = useState(false);
  const [empresaToDelete, setEmpresaToDelete] = useState('');

  const mostrarConfirmacion = (rut) => {
    setEmpresaToDelete(rut);
    setShowConfirmation(true);
  };

  const confirmarEliminarEmpresa = () => {
    const nuevasEmpresas = empresas.filter((empresa) => empresa.rut !== empresaToDelete);
    setEmpresas(nuevasEmpresas);
    setShowConfirmation(false);
  };

  const cancelarEliminarEmpresa = () => {
    setShowConfirmation(false);
  };
  const [nuevaEmpresa, setNuevaEmpresa] = useState({
    rut: '',
    direccion: '',
    representante: '',
    telefono: '',
    correo: '',
  });
  const estiloConImagen = {
    backgroundImage: 'url("/assets/Fondo.jpg")',
    backgroundSize: 'cover',
    backgroundRepeat: 'no-repeat',
    
  };

  const [currentPage, setCurrentPage] = useState(1);
  const itemsPerPage = 10;

  const handleChangeNuevaEmpresa = (e) => {
    const { name, value } = e.target;
    setNuevaEmpresa({ ...nuevaEmpresa, [name]: value });
  };

  const agregarEmpresa = () => {
    setEmpresas([...empresas, nuevaEmpresa]);
    setNuevaEmpresa({
      rut: '',
      direccion: '',
      representante: '',
      telefono: '',
      correo: '',
    });
  };



  // Lógica para la paginación
  const indexOfLastItem = currentPage * itemsPerPage;
  const indexOfFirstItem = indexOfLastItem - itemsPerPage;
  const currentItems = empresas.slice(indexOfFirstItem, indexOfLastItem);

  // Cambiar de página
  const paginate = (pageNumber) => setCurrentPage(pageNumber);

  return (
    <div className='flex'>
      <Sidebar />
      <div className='flex-1 p-4 ' style={estiloConImagen}>
      <h1 className='text-black text-2xl mb-4 flex items-center'>
  <GoPeople size={40} style={{ marginRight: '10px' }} />
  Gestión de Empresas
</h1>

        <button onClick={agregarEmpresa} className='bg-green-500 text-white p-2 mb-4'>
          Agregar Empresa
        </button>

        <table className='table-auto w-full border border-black'>
          <thead>
            <tr className='bg-[#07338C]'>
              <th className='border border-black px-4 py-2 text-white'>RUT</th>
              <th className='border border-black px-4 py-2 text-white'>Dirección</th>
              <th className='border border-black px-4 py-2 text-white'>Representante Legal</th>
              <th className='border border-black px-4 py-2 text-white'>Teléfono</th>
              <th className='border border-black px-4 py-2 text-white'>Correo</th>
              <th className='border border-black px-4 py-2 text-white'>Acciones</th>
            </tr>
          </thead>
          <tbody>
            {currentItems.map((empresas) => (
              <tr key={empresas.rut_empresa} className='bg-[#DCBBF2]'>
                <td className='border border-black px-4 py-2 text-black'>{empresas.rut_empresa}</td>
                <td className='border border-black px-4 py-2 text-black'>{empresas.direccion_emp}</td>
                <td className='border border-black px-4 py-2 text-black'>{empresas.representante_legal}</td>
                <td className='border border-black px-4 py-2 text-black'>{empresas.telefono_ejecutivo}</td>
                <td className='border border-black px-4 py-2 text-black'>{empresas.correo_ejecutivo}</td>
                <td className='border border-black px-4 py-2'>
                  <button className='bg-yellow-500 text-white p-1 mr-2'>Editar</button>
                  <button onClick={() => mostrarConfirmacion(empresas.rut_empresa)} className='bg-red-500 text-white p-1'>
                    Eliminar
                  </button>
                </td>
              </tr>
            ))}
          </tbody>
        </table>

        {/* Paginación */}
        <div className='mt-4'>
          {Array.from({ length: Math.ceil(empresas.length / itemsPerPage) }).map((_, index) => (
            <button key={index + 1} onClick={() => paginate(index + 1)} className='mx-1 px-3 py-1 bg-gray-200'>
              {index + 1}
            </button>
          ))}
        </div>
      </div>
      {showConfirmation && (
        <div className='fixed inset-0 z-50 flex items-center justify-center'>
          <div className='bg-white p-4 rounded shadow-md'>
            <p className='text-gray-800 mb-4'>¿Está seguro de que quieres eliminar esta empresa?</p>
            <div className='flex justify-end'>
              <button onClick={confirmarEliminarEmpresa} className='bg-red-500 text-white p-2 mr-2'>
                Sí
              </button>
              <button onClick={cancelarEliminarEmpresa} className='bg-gray-300 text-gray-800 p-2'>
                No
              </button>
            </div>
          </div>
        </div>
      )}
    </div>
  );
};

export default Empresas;
