import React, { useState, useEffect } from "react";

const EmpresaDatos = ({ label, value }) => {
  return (
    <div className="flex flex-col mb-4">
      <label className="mr-2 text-xl font-bold">{label}:</label>
      <div className="max-h-32 overflow-auto max-w-auto mt-">
        <p className="w-full">{value}</p>
      </div>
    </div>
  );
};

const ModalDetalles = React.memo(({ empresaSeleccionada, onClose }) => {
  const closeModal = () => {
    onClose();
  };
  const [formData, setFormData] = useState({
    rut: "",
    telefono: "",
    nombreEmpresa: "",
    representanteLegal: "",
    nombreEjecutivo: "",
    tipoSociedad: "",
    direccionE: "",
    correoElectronico: "",
    presentacionE: "",
    serviciosE: "",
    visionE: "",
    misionE: "",
  });

  useEffect(() => {
    if (empresaSeleccionada) {
      setFormData({
        rut: empresaSeleccionada.rut_empresa || "",
        telefono: empresaSeleccionada.telefono_ejecutivo || "",
        nombreEmpresa: empresaSeleccionada.nombre_empresa || "",
        representanteLegal: empresaSeleccionada.representante_legal || "",
        nombreEjecutivo: empresaSeleccionada.nombre_ejecutivo || "",
        tipoSociedad: empresaSeleccionada.tipo_sociedad || "",
        direccionE: empresaSeleccionada.direccion_emp || "",
        correoElectronico: empresaSeleccionada.correo_ejecutivo || "",
        presentacionE: empresaSeleccionada.presentacion_empresa || "",
        serviciosE: empresaSeleccionada.descripcion_servicios || "",
        visionE: empresaSeleccionada.vision_empresa || "",
        misionE: empresaSeleccionada.mision_empresa || "",
      });
    }
  }, [empresaSeleccionada]);

  return (
    <form className="overflow-auto max-h-screen max-w-7xl p-1">
      <div className="text-black w-1/2 border-b border-black mb-4">
        <h2 className="text-black text-2xl font-bold mb-[1px] ml-1">
          Datos Empresa
        </h2>
      </div>
      <div className="grid grid-cols-3 gap-1 text-black">
        <div>
          <EmpresaDatos
            label="Nombre de la Empresa"
            value={formData.nombreEmpresa}
          />
          <EmpresaDatos
            label="Tipo de Sociedad"
            value={formData.tipoSociedad}
          />
          <EmpresaDatos
            label="Correo Ejecutivo"
            value={formData.correoElectronico}
          />
        </div>

        <div>
          <EmpresaDatos label="Rut empresa" value={formData.rut} />
          <EmpresaDatos
            label="Representante Legal"
            value={formData.representanteLegal}
          />
          <EmpresaDatos
            label="Telefono de Ejecutivo"
            value={formData.telefono}
          />
        </div>

        <div>
          <EmpresaDatos
            label="Dirección de la Empresa"
            value={formData.direccionE}
          />
          <EmpresaDatos
            label="Nombre de ejecutivo"
            value={formData.nombreEjecutivo}
          />
        </div>
      </div>
      <div className="grid grid-cols-2 gap-4 text-black">
        <div>
          <EmpresaDatos
            label="Presetanción de la Empresa"
            value={formData.presentacionE}
          />
          <EmpresaDatos label="Visión de la Empresa" value={formData.visionE} />
        </div>
        <div>
          <EmpresaDatos
            label="Servicios de la Empresa"
            value={formData.serviciosE}
          />
          <EmpresaDatos label="Misión de la Empresa" value={formData.misionE} />
        </div>
      </div>
      <div className="mt-2 text-right">
        <button
          className="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg"
          onClick={closeModal}
        >
          Cancelar
        </button>
      </div>
    </form>
  );
});

ModalDetalles.displayName = "ModalDetalles"
export default ModalDetalles;
