"use client";
import React, { useEffect, useRef } from "react";
import {
  HomeIcon,
  ChartBarIcon,
  CheckCircleIcon,
  XCircleIcon,
} from "@heroicons/react/24/solid";
import Card from "../../components/card";
import CountUp from "react-countup";
import Chart from "chart.js/auto";

export default function Home() {
  const userChartRef = useRef(null);
  const companyChartRef = useRef(null);

  useEffect(() => {
    // Datos de ejemplo
    const datosUsuarios = [3000, 1500, 1000, 2000, 2500, 3000, 4000];
    const datosEmpresas = [200, 100, 150, 180, 350, 300, 220];

    // Gráfico para actividad de usuarios
    const graficoUsuarios = new Chart(userChartRef.current, {
      type: "bar",
      data: {
        labels: ["Ago", "Sept", "Oct", "Nov", "Dic", "Ene", "Feb"],
        datasets: [
          {
            label: "Usuarios",
            data: datosUsuarios,
            backgroundColor: "rgba(75, 192, 192, 0.2)",
            borderColor: "rgba(75, 192, 192, 1)",
            borderWidth: 1,
          },
        ],
      },
    });

    // Gráfico para actividad de empresas
    const graficoEmpresas = new Chart(companyChartRef.current, {
      type: "bar",
      data: {
        labels: ["Ago", "Sept", "Oct", "Nov", "Dic", "Ene", "Feb"],
        datasets: [
          {
            label: "Empresas",
            data: datosEmpresas,
            backgroundColor: "rgba(255, 99, 132, 0.2)",
            borderColor: "rgba(255, 99, 132, 1)",
            borderWidth: 1,
          },
        ],
      },
    });

    return () => {
      graficoUsuarios.destroy();
      graficoEmpresas.destroy();
    };
  }, []);

  return (
    <div className="flex flex-col flex-1 max-w-full">
      <div className="mb-2 max-w-full sm:max-w-sm  md:max-w-md lg:max-w-lg xl:max-w-xl">
        <h1 className="flex items-center text-3xl font-bold text-black border-b border-black pb-2 w-[90%]">
          <HomeIcon className="h-8 w-8 mr-1 mb-[5px]" /> Inicio
        </h1>
      </div>
      <div className="px-6 grid grid-cols-2 gap-4 mt-2">
        <Card>
          <div className="flex justify-between items-center">
            <h1 className="flex items-center text-3xl font-bold text-black pb-2 gap-2">
              <ChartBarIcon className="h-6 w-6" />
              Resumen del día
            </h1>

            <p className="text-gray-400">26-02-2024</p>
          </div>

          <div className="text-lg ml-8">
            <p className="text-black flex gap-2">
              <CheckCircleIcon className="w-6 h-6 text-green-500" />
              <CountUp end="3000" delay={1} duration={3} /> Postulaciones
              exitosas
            </p>

            <p className="text-black flex gap-2">
              <XCircleIcon className="w-6 h-6 text-red-500" />
              <CountUp end="200" delay={1} duration={3} /> Postulaciones
              fallidas
            </p>
          </div>
        </Card>

        <Card>
          <div className="flex justify-between items-center">
            <h1 className="flex items-center text-3xl font-bold text-black pb-2 gap-2">
              <ChartBarIcon className="h-6 w-6" />
              Resumen del mes
            </h1>

            <p className="text-gray-400">Febrero</p>
          </div>

          <div className="text-lg ml-8">
            <p className="text-black flex gap-2">
              <CheckCircleIcon className="w-6 h-6 text-green-500" />
              <CountUp end="15000" delay={1} duration={3} /> Postulaciones
              exitosas
            </p>

            <p className="text-black flex gap-2">
              <XCircleIcon className="w-6 h-6 text-red-500" />
              <CountUp end="4000" delay={1} duration={3} /> Postulaciones
              fallidas
            </p>
          </div>
        </Card>

        {/* Gráfico de actividad de empresas */}
        <Card className="mt-3">
          <div className="flex justify-between items-center">
            <h1 className="flex items-center text-3xl font-bold text-black pb-2 gap-2">
              <ChartBarIcon className="h-6 w-6" />
              Empresas activas
            </h1>
          </div>
          <canvas ref={companyChartRef}></canvas>
        </Card>

        {/* Gráfico de actividad de usuarios */}
        <Card className="mt-3">
          <div className="flex justify-between items-center">
            <h1 className="flex items-center text-3xl font-bold text-black pb-2 gap-2">
              <ChartBarIcon className="h-6 w-6" />
              Usuarios activos
            </h1>
          </div>
          <canvas ref={userChartRef}></canvas>
        </Card>
      </div>
    </div>
  );
}
