"use client";
import React, { useState, useEffect } from "react";
import Select from "react-select";
import {
  UserGroupIcon,
  DocumentIcon,
  PencilIcon,
  MagnifyingGlassIcon,
  TrashIcon,
} from "@heroicons/react/24/solid";
import Modal from "../../../components/admin/Modal.jsx";
import UsuarioForm from "./ModalEditAdd.jsx";
import ModalEliminar from "./ModalEliminar.jsx";
import ModalDetalles from "./ModalDetalles.jsx";
import { useSession } from "@/app/contexts/SessionContext.jsx";
import { getEmpresas } from "@/api/empresas.jsx";
import { getUsuariosEmpresa } from "@/api/usuarios.jsx";

export default function AdminUsuarios() {

  const { user } = useSession();
  // Estado para almacenar la empresa seleccionada
  const [empresaSeleccionada, setEmpresaSeleccionada] = useState(null);
  // Estado para almacenar la lista de usuarios
  const [listaUsuarios, setListaUsuarios] = useState([]);
  // Estado para almacenar la lista de empresas
  const [listaEmpresas, setListaEmpresas] = useState([]);
  const [listaPermisos, setListaPermisos] = useState([]);
  // Estado para almacenar el término de búsqueda
  const [busquedaUsuario, setBusquedaUsuario] = useState("");
  // Const para modals
  const [modalOpen, setModalOpen] = useState(false);
  const [accionUsuario, setAccionUsuario] = useState(null);
  const [usuarioSeleccionado, setUsuarioSeleccionado] = useState(null);
  const [mensajeContenido, setMensajeContenido] = useState("");
  const [mensajeVisible, setMensajeVisible] = useState(false);

  const openModal = (accion, usuario) => {
    setAccionUsuario(accion);
    setUsuarioSeleccionado(accion === "agregar" ? null : usuario);
    setModalOpen(true);
  };
  const closeModal = () => {
    setModalOpen(false);
  };

  const handleGuardarUsuario = async (accion, usuarioData) => {
    if (accion === "agregar") {
      // Lógica para agregar un nuevo usuario
      const nuevoUsuario = {
        id: listaUsuarios.length + 1,
        ...usuarioData,
      };
      setListaUsuarios([...listaUsuarios, nuevoUsuario]);
      mostrarMensaje(true, "Usuario agregado con éxito");
    } else if (accion === "editar") {
      const idUsuario = usuarioData.usuario_id.toString();
      const usuariosActualizados = listaUsuarios.map((usuario) =>
        usuario.usuario_id === idUsuario
          ? { ...usuario, ...usuarioData }
          : usuario
      );
      setListaUsuarios(usuariosActualizados);
      // Cerrar el modal después de actualizar el estado
      closeModal();
      mostrarMensaje(true, "Usuario editado con éxito");
    } else if (accion === "eliminar") {
      const nuevosUsuarios = listaUsuarios.filter(
        (usuario) => usuario.usuario_id !== usuarioSeleccionado.usuario_id
      );
      setListaUsuarios(nuevosUsuarios);
      mostrarMensaje(true, "Usuario eliminado con éxito");
    }
  };
  const mostrarMensaje = (isVisible, contenido) => {
    setMensajeContenido(contenido);
    setMensajeVisible(isVisible);
    // Ocultar el mensaje después de un tiempo (por ejemplo, 3 segundos)
    setTimeout(() => {
      setMensajeVisible(false);
    }, 3000);
  };
  // Función para manejar cambios en el input de búsqueda
  const handleBuscarUsuario = (event) => {
    setBusquedaUsuario(event.target.value);
  };
  // Filtrar usuarios según el término de búsqueda
  const usuariosFiltrados = listaUsuarios.filter(
    (usuario) =>
      (usuario.nombre_usuario &&
        usuario.nombre_usuario
          .toLowerCase()
          .includes(busquedaUsuario.toLowerCase())) ||
      (usuario.usuario_id &&
        usuario.usuario_id.toString().includes(busquedaUsuario)) ||
      (usuario.rut_usuario &&
        usuario.rut_usuario
          .toLowerCase()
          .includes(busquedaUsuario.toLowerCase()))
  );

  useEffect(() => {
    const fetchData = async () => { 
        try {
          if (user && user.token) {
            const empresasData = await getEmpresas(user.token);
            const listaEmpresas = empresasData.map(item => ({
              value: item.empresa_id,
              label: item.nombre_empresa
            }));
            console.log(listaEmpresas)
            setListaEmpresas(listaEmpresas);
          } 
        } catch (error) {
          console.error('Error al obtener las empresas:', error.message);
        }
    };

    fetchData();
  }, [user]);

/* 
  // Simulación de carga de datos desde la base de datos
  useEffect(() => {
    // Mueve la lógica de carga de datos a una función separada
    const cargarDatos = () => {
      const empresas = datosSimulados.map((empresa) => ({
        value: empresa.empresa_id,
        label: empresa.nombre_empresa,
      }));

      setListaEmpresas(empresas);

      const permisos = datosSimulados.flatMap((empresa) =>
        empresa.usuarios.flatMap((usuario) =>
          usuario.permisos_usuarios.map((permiso) => ({
            id: permiso.id_permisos_usr,
            value: permiso.nombre_permisos,
            label: permiso.nombre_permisos,
          }))
        )
      );

      const opcionesPermisos = Array.from(new Set(permisos)).map((permiso) => ({
        value: permiso.id,
        label: permiso.label,
      }));

      setListaPermisos(opcionesPermisos);
    };
    // Verifica si hay datos antes de cargarlos
    if (datosSimulados.length > 0) {
      cargarDatos();
    }
  }, [listaUsuarios, empresaSeleccionada]); */

  // Función para manejar cambios en la selección de empresa
  const handleSeleccionEmpresa = (selectedOption) => {
    
    const fetchUsuariosData = async () =>{
      try {
        if (user && user.token) {
          const usuariosData = await getUsuariosEmpresa(selectedOption.value ,user.token);
          console.log(usuariosData);
          setListaUsuarios(usuariosData.usuarios)
        } 
      } catch (error) {
        console.error('Error al obtener los usuarios:', error.message);
      }
    }

    fetchUsuariosData();

    setEmpresaSeleccionada(selectedOption);

    if (empresaSeleccionadaData) {
      setListaUsuarios(empresaSeleccionadaData.usuarios);
    } else {
      setListaUsuarios([]);
    }
  };

  return (
    <div className="flex flex-col flex-1 max-w-full">
      <div className="mb-2 max-w-full sm:max-w-sm  md:max-w-md lg:max-w-lg xl:max-w-xl">
        <h1 className="flex items-center text-3xl font-bold text-black border-b border-black pb-2 w-[90%]">
          <UserGroupIcon className="h-8 w-8 mr-1" /> Usuarios
        </h1>
      </div>

      <div className="flex  justify-center mt-4 text-black">
        <div className="flex flex-col">
          <div className="flex  justify-center">
            <h2 className="text-bold text-lg">
              Para cargar usuarios, seleccione empresa:
            </h2>
          </div>
          <div className="flex mt-2">
            {/* Selector de empresas con búsqueda */}
            <Select
              value={empresaSeleccionada}
              onChange={handleSeleccionEmpresa}
              options={listaEmpresas}
              isSearchable
              placeholder="Seleccione la empresa"
              className="w-96"
            />
          </div>
        </div>
      </div>

      <div className="flex justify-between mt-4">
        <button
          title="Agregar nuevo usuario"
          className={`text-white ${
            empresaSeleccionada ? "bg-sky-500 hover:bg-sky-600" : "bg-gray-400"
          } rounded-lg px-5 py-2 shadow drop-shadow-md ml-1`}
          onClick={() => {
            if (empresaSeleccionada) {
              openModal("agregar");
            } else {
              console.log("Selecciona una empresa antes de agregar usuario");
            }
          }}
          disabled={!empresaSeleccionada}
        >
          Agregar Usuario
        </button>
        <div className="relative">
          <MagnifyingGlassIcon className="absolute text-black left-3 top-1/2 transform -translate-y-1/2 h-5 w-5 text-gray-400" />
          <input
            type="search"
            className="text-black rounded-lg pl-10 border border-gray-400 py-2 px-3 mr-1"
            placeholder="Buscar..."
            value={busquedaUsuario}
            onChange={handleBuscarUsuario}
          />
        </div>
      </div>
      {mensajeVisible && (
        <div className="absolute bottom-2 right-2 bg-green-500 w-[20%] h-20 justify-center text-center font-bold text-white p-2 rounded-md m-2 flex items-center">
          {mensajeContenido}
        </div>
      )}
      <div>
        <table className="mt-1 table-auto w-full rounded-lg overflow-hidden shadow-xs">
          <thead>
            <tr className="bg-gray-400 text-black border-b border-gray-500">
              <th className="px-6 py-2">ID</th>
              <th className="px-6 py-2">Nombre</th>
              <th className="px-6 py-2">Detalles</th>
              <th className="px-6 py-2">Editar</th>
              <th className="px-6 py-2">Eliminar</th>
            </tr>
          </thead>
          {/* Contenido de la tabla */}
          <tbody>
            {usuariosFiltrados.map((usuario) => (
              <tr
                key={usuario.usuario_id}
                className="border-collapse text-black bg-gray-300 border-b text-center border-gray-500"
              >
                <td className="py-2 px-6">{usuario.usuario_id}</td>
                <td className="py-2 px-6">{usuario.nombre_usuario}</td>
                <td className="py-1 px-6 text-center items-center">
                  <button
                    title="Ver detalles del usuario"
                    className="cursor-pointer text-white rounded-sm border-blue-700 bg-blue-600 hover:bg-blue-400 p-1"
                    onClick={() => {
                      setUsuarioSeleccionado(usuario);
                      openModal("detalles", usuario);
                    }}
                  >
                    <DocumentIcon className="h-7 w-7 mx-auto" />
                  </button>
                </td>
                <td className="py-1 px-6 text-center items-center ">
                  <button
                    className="cursor-pointer text-white rounded-sm border-blue-700 bg-blue-600 hover:bg-blue-400 p-1"
                    title="Editar usuario"
                    onClick={() => {
                      setUsuarioSeleccionado(usuario);
                      openModal("editar", usuario);
                    }}
                  >
                    <PencilIcon className="h-7 w-7 mx-auto" />
                  </button>
                </td>
                <td className="py-2 px-6">
                  <button
                    className="cursor-pointer text-white rounded-sm border-red-700 bg-red-600 hover:bg-red-400 p-1"
                    title="Eliminar usuario"
                    onClick={() => {
                      setUsuarioSeleccionado(usuario);
                      openModal("eliminar", usuario);
                    }}
                  >
                    <TrashIcon className="h-7 w-7 mx-auto" />
                  </button>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
      <Modal isOpen={modalOpen} onClose={closeModal}>
        {accionUsuario === "eliminar" ? (
          <ModalEliminar
            accion={accionUsuario}
            usuario={usuarioSeleccionado}
            onClose={closeModal}
            onConfirm={handleGuardarUsuario}
          />
        ) : accionUsuario === "detalles" ? (
          <ModalDetalles
            accion={accionUsuario}
            usuario={usuarioSeleccionado}
            onClose={closeModal}
          />
        ) : (
          <UsuarioForm
            accion={accionUsuario}
            usuario={usuarioSeleccionado}
            listaPermisos={listaPermisos}
            onClose={closeModal}
            onSubmit={handleGuardarUsuario} // Ajusta el nombre de la función según sea necesario
          />
        )}
      </Modal>
    </div>
  );
}
