import React, { useState } from 'react'
import Card from './card'
import {
  IoMdDownload,
  IoIosArrowDown,
  IoIosArrowUp,
} from 'react-icons/io'

const PostulationCard = ({ data }) => {
  const [mostrarMas, setMostrarMas] = useState(false)

  const mostrarMasContenido = mostrarMas ? (
    <div>
      <p>
        <strong>Fecha subida:</strong> {data.fecha_subida}
      </p>
      <p>
        <strong>Fecha cierre:</strong> {data.fecha_cierre}
      </p>
      
    </div>
  ) : null

  const handleMostrarMas = () => {
    setMostrarMas(!mostrarMas)
  }

  const handlePostular = () => {
    // Lógica para postular
  }

  const handleDescargarPDF = (lic_id) => {
    // URL de la API con los parámetros necesarios

    const empresaItem = JSON.parse(localStorage.getItem("empresaData"))

    const apiUrl = process.env.API_URL+`/licitaciones/pdf/${lic_id}?empresa_id=${empresaItem.empresa_id}`;
    console.log(empresaItem)
  
    // Realiza la solicitud GET a la API
    fetch(apiUrl)
      .then(response => {
        // Verifica si la solicitud fue exitosa (código de estado 200)
        if (!response.ok) {
          throw new Error(`Error al descargar el PDF. Código de estado: ${response.status}`);
        }
        return response.blob();
      })
      .then(blob => {
        // Crea un enlace temporal y realiza la descarga del PDF
        const link = document.createElement("a");
        link.href = window.URL.createObjectURL(blob);
        link.download = `documento_${lic_id}.pdf`;  // Establece el nombre del archivo
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
      })
      .catch(error => {
        console.error(error);
        // Manejo de errores, puedes mostrar un mensaje al usuario si es necesario
      });
  };

  const formatNumberToCLP = (number) => {
    return new Intl.NumberFormat('es-CL', {
      style: 'currency',
      currency: 'CLP',
    }).format(number);
  };
  
  return (
    <Card className="text-slate-700">
      <div className="flex justify-between">
      <p className='text-xl'>
        <strong>{data.nombre}</strong> 
      </p>
      <strong className="text-slate-600">
        {data.id} 
      </strong>
      </div>
      
      <p>
        <strong>Institución:</strong> {data.institucion}
      </p>
      
      <p>
      <strong>Monto:</strong> {formatNumberToCLP(data.monto)}
        {mostrarMasContenido}
      </p>
      <div className='flex justify-between items-center'>
        <button
          className='bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded mt-2 flex items-center mr-2'
          onClick={handleMostrarMas}
        >
          {mostrarMas ? (
            <>
              <IoIosArrowUp className='mr-2' size={20} />
              Ver menos
            </>
          ) : (
            <>
              <IoIosArrowDown className='mr-2' size={20} />
              Ver más
            </>
          )}
        </button>
        <div className='flex'>
          <button
  className='bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded mt-2 flex items-center'
  onClick={() => handleDescargarPDF(data.id)}
>
  <IoMdDownload className='mr-2' size={20} />
    Descargar PDF
  </button>
        </div>
      </div>
    </Card>
  )
}

export default PostulationCard
