import React, { useState } from 'react';
import {
  IoMdDownload
} from 'react-icons/io';

const Card = ({ data }) => {
  
  const {
    ID: id,
    Proyecto: proyecto,
    fecha_subida,
    fecha_postulacion,
  } = data;


  const handleDescargarPDF = () => {
    // Lógica para descargar PDF
  };
 
  return (
    <div className='border border-[#07338C] p-4 rounded-md mx-4 bg-[#073673] my-4 '>
      <div className="flex justify-between">
        <div className="flex flex-col">
          <p>
            <strong>ID:</strong> {id}
          </p>
          <p>
            <strong>Proyecto:</strong> {proyecto}
          </p>
          <p>
            <strong>Fecha de subida:</strong> {fecha_subida}
          </p>
          <p>
            <strong>Fecha de postulación:</strong> {fecha_postulacion}
          </p>
        </div>
      </div>
      <div className='flex justify-end mt-2'>
        <button
          className='bg-red-500  hover:bg-red-700 text-white font-bold py-2 px-4 rounded flex items-center'
          onClick={handleDescargarPDF}
        >
          <IoMdDownload className='mr-2' size={20} />
          Descargar PDF
        </button>
      </div>
    </div>
  );
  
};

export default Card;