import { useState } from "react";
import Image from "next/image";
import Link from "next/link";
import { HomeIcon, DocumentIcon, DocumentCheckIcon, BuildingOfficeIcon, Cog6ToothIcon  } from '@heroicons/react/24/solid'

const Sidebar = () => {
  const [open, setOpen] = useState(false);
  const [hoveredIndex, setHoveredIndex] = useState(null);

  const Menus = [
    { title: "Inicio", 
      icon: <HomeIcon className="w-8 h-8"/>, 
      link: "/dashboard" },
    {
      title: "Postulaciones",
      icon: <DocumentIcon className="w-8 h-8" />,
      link: "/dashboard/postulaciones",
    },
    {
      title: "Ordenes de Compra",
      icon: <DocumentCheckIcon className="w-8 h-8" />,
      link: "/dashboard/ordenescompra",
    },
    {
      title: "Empresa",
      icon: <BuildingOfficeIcon className="h-8 w-8" />,
      link: "/dashboard/empresa",
    },
    {
      title: "Configuración",
      icon: <Cog6ToothIcon className="w-8 h-8" />,
      link: "/dashboard/configuracion",
    },
  ];

  const handleMouseEnter = (index) => {
    setHoveredIndex(index);
  };

  const handleMouseLeave = () => {
    setHoveredIndex(null);
  };

  const handleItemClick = (index) => {
    // Aquí puedes agregar lógica para animaciones al hacer clic
    console.log(`Item clicked: ${Menus[index].title}`);
  };

  return (
    <div className="flex">
      <div
        className={`${
          open ? "w-64" : "w-24"
        } bg-blue-400 min-h-screen p-5 pt-4 relative duration-300`}
        style={{ backgroundColor: open ? "#242745" : "#242745" }}
      >
        <Image
          src="/assets/control.png"
          alt="Toggle Sidebar"
          width={28}
          height={28}
          className={`absolute cursor-pointer -right-3 top-9 w-7
          border-2 ${open ? "#07338C" : "border-073673"} rounded-full ${
            !open && "rotate-180"
          }`}
          onClick={() => setOpen(!open)}
        />
        <div className="flex gap-x-4 items-center">
          <Image
            src="/assets/LOGO.png"
            alt="logo"
            width={80}
            height={80}
            className={`cursor-pointer duration-500 ${
              open && "rotate-[360deg]"
            }`}
          />
          <h1
            className={`text-white origin-left font-medium text-xl duration-200 ${
              !open && "scale-0"
            }`}
          >
            Venturix
          </h1>
        </div>
        <ul
          className={`pt-6 flex flex-wrap ${
            open ? "flex-col" : "justify-start"
          }`}
        >
          {Menus.map((Menu, index) => {
            const isItemSelected = index === 0;
            const showMenuText = open ? "" : "hidden";

            // Verificar el atributo show y renderizar el elemento solo si show es undefined o true
            return (
              <Link href={Menu.link} key={index}>
                <li
                  className={`
                    flex rounded-md p-2 cursor-pointer hover:bg-light-white text-gray-300 text-sm items-center gap-x-4
                    ${Menu.gap ? "mt-9" : "mt-2"}
                    ${isItemSelected ? "bg-light-white" : ""}
                  `}
                  onClick={() => handleItemClick(index)}
                >
                  <span
                    onMouseEnter={() => handleMouseEnter(index)}
                    onMouseLeave={handleMouseLeave}
                    className="flex items-center" // Nueva clase para alinear los elementos horizontalmente
                  >
                    <span
                      data-tip={Menu.title}
                      data-event="click"
                      data-event-off="mouseleave"
                      className={`transition-transform transform ${
                        hoveredIndex === index ? "scale-110" : ""
                      }`}
                      style={{ marginRight: "12px" }}
                    >
                      {Menu.icon}
                    </span>
                    <span
                      className={`origin-left duration-200 ${showMenuText}`}
                    >
                      {Menu.title}
                    </span>
                  </span>
                </li>
              </Link>
            );
          })}
        </ul>
      </div>
    </div>
  );
};

export default Sidebar;
